<?php
echo "Testing curl-impersonate with PHP...\n\n";

$ch = curl_init('https://tls.peet.ws/api/all');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);

$response = curl_exec($ch);
$error = curl_error($ch);
$info = curl_getinfo($ch);

curl_close($ch);

if ($error) {
    echo "Error: $error\n";
    exit(1);
}

echo "HTTP Code: " . $info['http_code'] . "\n";
echo "TLS Version: " . ($info['ssl_version'] ?? 'N/A') . "\n\n";

$data = json_decode($response, true);
if ($data && isset($data['tls'])) {
    echo "TLS Fingerprint detected:\n";
    echo "JA3: " . ($data['tls']['ja3'] ?? 'N/A') . "\n";
    echo "JA3 Hash: " . ($data['tls']['ja3_hash'] ?? 'N/A') . "\n";
}

echo "\nTest completed successfully!\n";
?>
